/*
 * @(#)OMBshApplicationModel.java  1.0  2006-06-18
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.oo;

import ch.hslu.cm.oo.diagram.OMAssociationFigure;
import ch.hslu.cm.oo.diagram.OMBidirectionalLinkFigure;
import ch.hslu.cm.oo.diagram.OMDependencyFigure;
import ch.hslu.cm.oo.diagram.OMGeneralizationFigure;
import ch.hslu.cm.oo.diagrambsh.ClassFigureBsh;
import ch.hslu.cm.oo.diagrambsh.DraggableMessageFigureBsh;
import ch.hslu.cm.oo.diagrambsh.ObjectFigureBsh;
import ch.hslu.cm.oo.objectmodel.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.DefaultMenuBuilder;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.liner.ElbowLiner;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.TextAreaCreationTool;
import org.jhotdraw.draw.tool.TextCreationTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * OMBshApplicationModel.
 * 
 * 
 * @author Werner Randelshofer.
 * @version 1.0 2006-06-18 Created.
 */
public class OMBshApplicationModel extends DefaultApplicationModel {
    private static class ToolButtonListener implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;
        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }
        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == ItemEvent.SELECTED) {
                editor.setTool(tool);
            }
        }
    }
    /**
     * This editor is shared by all projects.
     */
    private DefaultDrawingEditor sharedEditor;
    
    /** Creates a new instance. */
    public OMBshApplicationModel() {
    }
    
    public DefaultDrawingEditor getSharedEditor() {
        if (sharedEditor == null) {
            sharedEditor = new DefaultDrawingEditor();
        }
        return sharedEditor;
    }
    
    @Override
    public void initView(Application a, View p) {
        if (a.isSharingToolsAmongViews()) {
            ((OMBshView) p).setEditor(getSharedEditor());
        }
    }
    private void addCreationButtonsTo(JToolBar tb, final DrawingEditor editor) {
        
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.oo.Labels");
        
        ButtonFactory.addSelectionToolTo(tb, editor);
        tb.addSeparator();
        
        OMAssociationFigure assoF;
        
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new ClassFigureBsh()), "edit.createClass", labels);
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(new OMGeneralizationFigure()), "edit.createGeneralization", labels);
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(assoF = new OMAssociationFigure()), "edit.createAssociation11", labels);
        assoF.getModel().setOwnerMultiplicity(1);
        assoF.getModel().setMemberMultiplicity(1);
        assoF.setLiner(new ElbowLiner());
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(assoF = new OMAssociationFigure()), "edit.createAssociation1M", labels);
        assoF.getModel().setOwnerMultiplicity(1);
        assoF.getModel().setMemberMultiplicity(OMAssociation.MANY_MULTIPLICITY);
        assoF.setLiner(new ElbowLiner());
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(assoF = new OMAssociationFigure()), "edit.createAssociationMM", labels);
        assoF.getModel().setOwnerMultiplicity(OMAssociation.MANY_MULTIPLICITY);
        assoF.getModel().setMemberMultiplicity(OMAssociation.MANY_MULTIPLICITY);
        assoF.setLiner(new ElbowLiner());
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(new OMDependencyFigure()), "edit.createDependency", labels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new ObjectFigureBsh()), "edit.createObject", labels);
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(new OMBidirectionalLinkFigure()), "edit.createLink", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new DraggableMessageFigureBsh()), "edit.createMessage", labels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new TextAreaCreationTool(new TextAreaFigure()), "edit.createTextArea", labels);
    }

    @Override
    protected MenuBuilder createMenuBuilder() {
        DefaultMenuBuilder mb= (DefaultMenuBuilder) super.createMenuBuilder();
        mb.setSuppressIcons(true);
        return mb;
    }


    /**
     * Creates toolbars for the application.
     * This class always returns an empty list. Subclasses may return other
     * values.
     */
    @Override
    public List<JToolBar> createToolBars(Application a, View pr) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        OMBshView p = (OMBshView) pr;
        
        DrawingEditor editor;
        if (p == null) {
            editor = getSharedEditor();
        } else {
            editor = p.getEditor();
        }
        
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb;
        tb = new JToolBar();
        addCreationButtonsTo(tb, editor);
        tb.setName(labels.getString("window.drawToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAttributesButtonsTo(tb, editor);
        tb.setName(labels.getString("window.attributesToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(labels.getString("window.alignmentToolBar.title"));
        list.add(tb);
        return list;
    }
    
    @Override
    public URIChooser createOpenChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml","xml"));
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml","xml"));
        return c;
    }
}
